<?php
if ($error) { ?>
    <div class="alert alert-danger"><i class="fa fa-bug fa-fw"></i> <?php echo $error; ?></div>
<?php } else { ?>
    <div class="enter_card <?php echo $saved_cc_list ? 'hidden' : '' ?>">
        <?php echo $form_open; ?>
        <h4 class="heading4"><?php echo $text_credit_card; ?></h4>
        <?php echo $this->getHookVar('payment_table_pre'); ?>
        <div class="form-group form-inline control-group">
            <span class="subtext"><?php echo $entry_billing_address; ?>: <?php echo $payment_address; ?>...</span>
            <div class="col-sm-2 input-group controls">
                <a href="<?php echo $edit_address; ?>" target="_new_mp_window" class="btn btn-default btn-sm">
                    <i class="fa fa-edit fa-fw"></i>
                    <?php echo $entry_edit; ?>
                </a>
            </div>
        </div>

        <div class="form-group control-group">
            <label class="col-sm-4 control-label"><?php echo $entry_cc_owner; ?></label>
            <div class="col-sm-7 input-group controls">
                <input type="text" class="form-control " placeholder="Name on the card:"
                       value="<?php echo $cc_owner->value; ?>" id="cc_owner" name="cc_owner">
                <input type="hidden" value="" id="pi_source" name="pi_source">
            </div>
            <span class="help-block"></span>
        </div>
        <div class="form-group form-inline control-group">
            <label class="col-sm-4 control-label"><?php echo $entry_cc_number; ?></label>
            <div id="card-element" class="col-sm-7 input-group field"
                 style="border: 1px solid #ccc; padding: 2px; min-width: 250px;"></div>
            <input type="hidden" name="cc_token" id="cc_token">
            <?php if ($save_cc) { ?>
                <div class="input-group col-sm-2 ml10">
                    <label>
                        <a data-toggle="tooltip"
                           data-original-title="<?php echo $entry_cc_save_details; ?>"><?php echo $entry_cc_save; ?></a>
                    </label>
                    <input type="checkbox" value="1" id="save_cc" name="save_cc"
                           style="position: relative; margin-left: 0;">
                </div>
            <?php } ?>
            <span class="help-block"></span>
        </div>
        <?php echo $this->getHookVar('payment_table_post'); ?>
        <div class="form-group action-buttons text-center">
            <a id="<?php echo $back->name ?>" href="<?php echo $back->href; ?>" class="btn btn-default mr10">
                <i class="fa fa-arrow-left"></i>
                <?php echo $back->text ?>
            </a>
            <button id="<?php echo $submit->name ?>" class="btn btn-orange" title="<?php echo $submit->text ?>"
                    type="submit">
                <i class="fa fa-check"></i>
                <?php echo $submit->text; ?>
            </button>
        </div>
        </form>
    </div>
    <?php
    if ($saved_cc_list) { ?>
        <div class="saved_cards">
            <form class="stripe-form" method="post" enctype="multipart/form-data">
                <h4 class="heading4"><?php echo $text_saved_credit_card; ?></h4>
                <div class="form-group form-inline control-group">
                    <span class="subtext"><?php echo $entry_billing_address; ?>: <?php echo $payment_address; ?>...</span>
                    <div class="col-sm-2 input-group controls">
                        <a href="<?php echo $edit_address; ?>" target="_new_mp_window" class="btn btn-default btn-sm">
                            <i class="fa fa-edit fa-fw"></i>
                            <?php echo $entry_edit; ?>
                        </a>
                    </div>
                </div>

                <div class="form-group form-inline control-group">
                    <div class="col-sm-3 input-group">
                        <select class="form-control input-medium short" id="use_saved_cc" name="use_saved_cc">
                            <?php
                            foreach ($saved_cc_list->options as $v => $option) {
                                echo '<option value="'.$v.'">'.$option.'</option>';
                            } ?>
                        </select>
                    </div>
                    <div class="col-sm-1 input-group controls">
                        <a id="delete_card" class="btn btn-default btn-sm"
                           title="<?php echo $text_delete_saved_credit_card; ?>">
                            <i class="fa fa-trash-o fa-fw"></i>
                            <?php echo $text_delete_saved_credit_card; ?>
                        </a>
                    </div>
                    <div class="col-sm-1 input-group">
                        <a id="new_card" class="btn btn-info btn-sm" title="<?php echo $text_new_credit_card; ?>">
                            <i class="fa fa-plus fa-fw"></i>
                            <?php echo $text_new_credit_card; ?>
                        </a>
                    </div>
                </div>

                <div class="form-group action-buttons text-center">
                    <a id="<?php echo $back->name ?>" href="<?php echo $back->href; ?>" class="btn btn-default mr10">
                        <i class="fa fa-arrow-left"></i>
                        <?php echo $back->text ?>
                    </a>
                    <button id="<?php echo $submit->name ?>" class="btn btn-orange" title="<?php echo $submit->text ?>"
                            type="submit">
                        <i class="fa fa-check"></i>
                        <?php echo $submit->text; ?>
                    </button>
                </div>
            </form>
        </div>

    <?php } ?>
    <script src="https://js.stripe.com/v3/"></script>
    <script type="text/javascript">
        if (typeof window['loadScript'] !== "function") {
            //when try to load script from ajax-response
            function loadScript(url, callback) {
                var script = document.createElement("script")
                script.type = "text/javascript";

                if (script.readyState) {  //IE
                    script.onreadystatechange = function () {
                        if (script.readyState == "loaded" ||
                            script.readyState == "complete") {
                            script.onreadystatechange = null;
                            callback();
                        }
                    };
                } else {  //Others
                    script.onload = function () {
                        callback();
                    };
                }

                script.src = url;
                document.getElementsByTagName("head")[0].appendChild(script);
            }
        }
        jQuery(document).ready(function () {
            loadScript("https://js.stripe.com/v3/", initStripe);
            var submitSent = false;
            $('#enter_card').hover(function () {
                $(this).tooltip('show');
            });

            $('#new_card').click(function () {
                $('.saved_cards').remove();
                $('.enter_card').removeClass('hidden');
            });

            $('#delete_card').click(function () {
                var $form = $('.saved_cards>form');
                confirmSubmit($form, 'index.php?rt=<?php echo $stripe_rt; ?>/delete_card');
                return false;
            });

            //validate submit
            $('form.stripe-form').submit(function (event) {
                event.preventDefault();
                if (submitSent !== true) {
                    submitSent = true;
                    //get card token first
                    var $form = $(this);
                    var handle;

                    $('.alert').remove();
                    $form.find('.action-buttons')
                        .hide()
                        .before(
                            '<div class="wait alert alert-info text-center"><i class="fa fa-refresh fa-spin fa-fw"></i> <?php echo $text_wait; ?></div>'
                        );

                    if ($('#use_saved_cc').length > 0) {
                        handle = stripe.handleCardPayment(
                            <?php js_echo($client_secret);?>,
                            {
                                source: $('#use_saved_cc').val(),
                            }
                        );
                    } else {
                        var source_data = {
                            source_data: {
                                owner: {
                                    name: $('input[name=cc_owner]').val(),
                                    address: {
                                        "city": <?php js_echo($payment_city); ?>,
                                        "country": <?php js_echo($payment_country); ?>,
                                        "line1": <?php js_echo($payment_address_1); ?>,
                                        "line2": <?php js_echo($payment_address_2); ?>,
                                        "postal_code": <?php js_echo($payment_postcode); ?>,
                                        "state": <?php js_echo($payment_zone); ?>
                                    },
                                    email: <?php js_echo($email);?>
                                }
                            },
                            save_payment_method: $('#save_cc').attr('checked') === 'checked'
                        };
                        <?php if($telephone){ ?>
                        source_data.source_data.owner.phone =  <?php js_echo($telephone); ?>;
                        <?php } ?>
                        handle = stripe.handleCardPayment(
                            <?php js_echo($client_secret);?>,
                            card,
                            source_data
                        );
                    }

                    handle.then(function (result) {
                        if (result.error) {
                            //console.log(result);
                            // Display error.message in your UI.
                            resetLockBtn();
                            alert(result.error.message);
                            $('.wait').remove();
                            $form.find('.action-buttons').show();
                            submitSent = false;
                        } else {
                            $('input[name=pi_source]').val(result.paymentIntent.source);
                            confirmSubmit($form, '<?php echo $action; ?>');
                        }
                    });
                    return false;
                }
            });

            function initStripe() {
                if (Stripe === undefined) {
                    return;
                }
                stripe = Stripe(
                    '<?php echo $public_key;?>',
                    {
                        betas: ['payment_intent_beta_3']
                    }
                );
                elements = stripe.elements();
                card = elements.create('card', {
                    hidePostalCode: true,
                    style: {
                        base: {
                            iconColor: '#666EE8',
                            color: '#31325F',
                            lineHeight: '40px',
                            fontWeight: 300,
                            fontFamily: '"Helvetica Neue", Helvetica, sans-serif',
                            fontSize: '15px',
                            '::placeholder': {
                                color: '#CFD7E0',
                            },
                        },
                    }
                });
                card.mount('#card-element');
            }

            function confirmSubmit($form, url) {
                $.ajax({
                    type: 'POST',
                    url: url,
                    data: $form.serialize(),
                    dataType: 'json',
                    success: function (data) {
                        if (!data) {
                            $('.wait').remove();
                            $form.find('.action-buttons').show();
                            $form.before('<div class="alert alert-danger"><i class="fa fa-bug fa-fw"></i> <?php echo $error_unknown; ?></div>');
                            submitSent = false;
                            try {
                                resetLockBtn();
                            } catch (e) {
                            }
                        } else {
                            if (data.error) {
                                $('.wait').remove();
                                $form.find('.action-buttons').show();
                                $form.before('<div class="alert alert-warning"><i class="fa fa-exclamation fa-fw"></i> ' + data.error + '</div>');
                                submitSent = false;
                                $form.find('input[name=csrfinstance]').val(data.csrfinstance);
                                $form.find('input[name=csrftoken]').val(data.csrftoken);
                                try {
                                    resetLockBtn();
                                } catch (e) {
                                }
                            }
                            if (data.success) {
                                location = data.success;
                            }
                        }
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        $('.wait').remove();
                        $form.find('.action-buttons').show();
                        $form.before('<div class="alert alert-danger"><i class="fa fa-exclamation fa-fw"></i> ' + textStatus + ' ' + errorThrown + '</div>');
                        submitSent = false;
                        try {
                            resetLockBtn();
                        } catch (e) {
                        }
                    }
                });
            }
        });

    </script>
<?php } ?>