<?php

/**
 * Class ControllerResponsesExtensionStripe
 *
 * @property ModelExtensionStripe $model_extension_stripe
 */
class ControllerResponsesExtensionStripe extends AController
{
    public $data = [];

    public function main()
    {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);
        $this->loadLanguage('stripe/stripe');
        $this->data['action'] = $this->html->getSecureURL('extension/stripe/send');
        //build submit form
        $form = new AForm();
        $form->setForm(
            [
                'form_name' => 'stripe',
            ]
        );

        $this->data['form_open'] = $form->getFieldHtml(
            [
                'type' => 'form',
                'name' => 'stripe',
                'attr' => 'class = "stripe-form"',
                'csrf' => true,
            ]
        );

        //need an order details
        $this->loadModel('checkout/order');
        $order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);
        $this->data['payment_address'] = $order_info['payment_address_1']." ".$order_info['payment_address_2'];

        $this->data['edit_address'] = $this->html->getSecureURL('checkout/address/payment');
        $this->data['email'] = $order_info['email'];
        $this->data['telephone'] = $order_info['telephone'];
        $this->data['payment_country'] = $order_info['payment_iso_code_2'];
        $this->data['payment_zone'] = $order_info['payment_zone_code'];

        $this->data['payment_address_1'] = trim($order_info['payment_address_1']);
        $this->data['payment_address_2'] = trim($order_info['payment_address_2']);
        $this->data['payment_city'] = trim($order_info['payment_city']);
        $this->data['payment_postcode'] = trim($order_info['payment_postcode']);

        $this->data['text_credit_card'] = $this->language->get('text_credit_card');
        $this->data['text_wait'] = $this->language->get('text_wait');

        $this->data['entry_cc_owner'] = $this->language->get('entry_cc_owner');
        $this->data['cc_owner'] = $form->getFieldHtml(
            [
                'type'        => 'input',
                'name'        => 'cc_owner',
                'placeholder' => $this->language->get('entry_cc_owner'),
                'value'       => $order_info['payment_firstname'].' '.$order_info['payment_lastname'],
            ]
        );

        $this->data['button_confirm'] = $this->language->get('button_confirm');
        $this->data['button_back'] = $this->language->get('button_back');

        if ($this->request->get['rt'] == 'checkout/guest_step_3') {
            $back_url = $this->html->getSecureURL('checkout/guest_step_2', '&mode=edit', true);
        } else {
            $back_url = $this->html->getSecureURL('checkout/payment', '&mode=edit', true);
        }
        $this->data['back'] = $this->html->buildElement(
            [
                'type'  => 'button',
                'name'  => 'back',
                'text'  => $this->language->get('button_back'),
                'style' => 'button',
                'href'  => $back_url,
                'icon'  => 'icon-arrow-left',
            ]
        );

        $this->data['submit'] = $this->html->buildElement(
            [
                'type'  => 'button',
                'name'  => 'stripe_button',
                'text'  => $this->language->get('button_confirm'),
                'style' => 'button btn-orange pull-right',
                'icon'  => 'icon-ok icon-white',
            ]
        );
        $this->data['stripe_ssl_off_error'] = $this->language->get('stripe_ssl_off_error');
        $this->buildCardForm($order_info);

        $this->view->batchAssign($this->data);

        //init controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);

        $this->processTemplate('responses/stripe.tpl');
    }

    protected function buildCardForm($order_info)
    {
        $this->data['stripe_rt'] = 'extension/stripe';
        $this->data['public_key'] = $this->config->get('stripe_test_mode')
                                    ? $this->config->get('stripe_pk_test')
                                    : $this->config->get('stripe_pk_live');
        $currency = $this->currency->getCode();

        if ($this->customer->getId() > 0) {
            $customer_stripe_id = $this->model_extension_stripe->getStripeCustomerID($this->customer->getId());
            //load credit cards list
            $source_list = [];
            if ($customer_stripe_id) {
                $sources = $this->model_extension_stripe->getStripeCustomerSources($customer_stripe_id);
                if (is_array($sources)) {
                    foreach ($sources as $src) {
                        if (strpos($src->id, 'src_') === 0 && $src->usage == 'reusable'
                            && $src->status == 'chargeable') {
                            //remove duplicates
                            if (in_array($src->card->brand.' XXXX XXXX XXXX '.$src->card->last4, $source_list)) {
                                continue;
                            }
                            $source_list[$src->id] = $src->card->brand.' XXXX XXXX XXXX '.$src->card->last4;
                        }
                    }
                    if (count($source_list) && $this->config->get('stripe_save_cards')
                    ) {
                        $this->data['saved_cc_list'] = HtmlElementFactory::create(
                            [
                            'type'    => 'selectbox',
                            'name'    => 'use_saved_cc',
                            'value'   => '',
                            'options' => $source_list,
                            ]
                        );
                    }
                }
            } else {
                $customer_stripe_id = $this->model_extension_stripe->createStripeCustomer($this->customer);
            }

            //option to save creditcard if limit is not reached
            if (!$this->session->data['guest'] && $this->config->get('stripe_save_cards')
                && count($source_list) < $this->config->get('stripe_save_cards_limit')
            ) {
                $this->data['save_cc'] = HtmlElementFactory::create(
                    [
                    'type'    => 'checkbox',
                    'name'    => 'save_cc',
                    'value'   => '1',
                    'checked' => false,
                    ]
                );
            }
        }

        $paymentIntent = $this->model_extension_stripe->createPaymentIntent(
            [

                'payment_method_types' => ["card"],
                'capture_method'       => $this->config->get('stripe_settlement'),
                'amount'               => round(
                                                $this->currency->convert(
                                                    $this->cart->getFinalTotal(),
                                                    $this->config->get('config_currency'),
                                                    $currency),
                                                2)
                                        * 100,
                'currency'             => $currency,
                'customer'             => $customer_stripe_id,
                'receipt_email'        => $this->customer->getEmail(),
                'shipping'             => [
                    'address' =>
                        [
                            'line1'       => $order_info['shipping_address_1'],
                            'city'        => $order_info['shipping_city'],
                            'country'     => $order_info['shipping_country'],
                            'line2'       => $order_info['shipping_address_2'],
                            'postal_code' => $order_info['shipping_postcode'],
                            'state'       => $order_info['shipping_zone'],
                        ],
                    'name'    => $order_info['shipping_firstname'].' '.$order_info['shipping_lastname'],
                    'carrier' => $order_info['shipping_method'],
                    'phone'   => $order_info['telephone'],
                ],
                'statement_descriptor' => 'Order #'.$order_info['order_id'],
                "metadata"             => [
                    "order_id" => $order_info['order_id'],
                ],
            ]
        );

        if ($paymentIntent['error']) {
            $this->data['error'] = $paymentIntent['error'];
            $this->messages->saveWarning('Stripe Error',
                $paymentIntent['error'].' OrderID:'.$order_info['order_id']);
        } else {
            $this->data['client_secret'] = $paymentIntent['client_secret'];
            $this->session->data['stripe']['pi_id'] = $paymentIntent['id'];
        }

    }

    public function send()
    {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);
        $this->loadLanguage('stripe/stripe');

        //validate input
        $post = $this->request->post;
        $order_id = $this->session->data['order_id'];

        if (isset($json['error'])) {
            $this->log->write('111');
            $csrftoken = $this->registry->get('csrftoken');
            $json['csrfinstance'] = $csrftoken->setInstance();
            $json['csrftoken'] = $csrftoken->setToken();
            $this->load->library('json');
            $this->response->setOutput(AJson::encode($json));
            return null;
        }

        $this->loadModel('checkout/order');
        $this->loadModel('extension/stripe');
        $this->loadLanguage('stripe/stripe');

        $p_result = [];
        try {

            $pi_id = $this->session->data['stripe']['pi_id'];
            if ($this->model_extension_stripe->isPaymentIntentSuccessful($pi_id)) {
                $p_result['paid'] = true;
                $this->load->model('checkout/order');
                $order_info = $this->model_checkout_order->getOrder($order_id);
                $this->model_extension_stripe->recordOrder($order_info, ['id' => $pi_id]);

                if ($this->config->get('stripe_settlement') == 'automatic') {
                    //auto complete the order in settled mode
                    $this->model_checkout_order->confirm(
                        $order_id,
                        $this->config->get('stripe_status_success_settled')
                    );
                } else {
                    //complete the order in unsettled mode
                    $this->model_checkout_order->confirm(
                        $order_id,
                        $this->config->get('stripe_status_success_unsettled')
                    );
                }

            } else {
                // Some other error, assume payment declined
                $this->model_checkout_order->addHistory(
                    $order_id,
                    $this->config->get('stripe_status_decline'),
                    'Unsuccessful payment Intent. ID '.$pi_id.'.'
                );
            }
        } catch (\Exception $e) {
            $p_result['error'] = $e->getMessage();
        }

        ADebug::variable('Processing payment result: ', $p_result);
        if ($p_result['error']) {
            // transaction failed
            $json['error'] = (string)$p_result['error'];
            if ($p_result['code']) {
                $json['error'] .= ' ('.$p_result['code'].')';
            }
        } else {
            if ($p_result['paid']) {
                $json['success'] = $this->html->getSecureURL('checkout/success');
            } else {
                //Unexpected result
                $json['error'] = $this->language->get('error_system');
            }
        }

        if (isset($json['error'])) {
            if ($json['error']) {
                $csrftoken = $this->registry->get('csrftoken');
                $json['csrfinstance'] = $csrftoken->setInstance();
                $json['csrftoken'] = $csrftoken->setToken();
            }
        }

        //init controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);

        $this->load->library('json');
        $this->response->setOutput(AJson::encode($json));
    }

    public function delete_card()
    {
        if (!$this->config->get('stripe_save_cards')) {
            return;
        }
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);
        $this->loadLanguage('stripe/stripe');

        //validate input
        $post = $this->request->post;
        if (empty($post['use_saved_cc'])) {
            $json['error'] = $this->language->get('error_system');
        }
        if (!$this->customer->getId()) {
            $json['error'] = $this->language->get('error_system');
        }
        if (isset($json['error'])) {
            $this->load->library('json');
            $this->response->setOutput(AJson::encode($json));
            return null;
        }

        $this->loadModel('extension/stripe');

        $customer_stripe_id = $this->model_extension_stripe->getStripeCustomerID($this->customer->getId());
        $deleted = $this->model_extension_stripe->deleteSource($post['use_saved_cc'], $customer_stripe_id);

        if (!$deleted) {
            // transaction failed
            $json['error'] = $this->language->get('error_system');
        } else {
            //basically reload the page
            $json['success'] = $this->html->getSecureURL('checkout/confirm');
        }

        //init controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);

        $this->load->library('json');
        $this->response->setOutput(AJson::encode($json));
    }

}