<?php

if (!class_exists('ExtensionStripe')) {
    require_once(DIR_EXT.'stripe/vendor/autoload.php');
    require_once(DIR_EXT.'stripe/core/stripe_hooks.php');
}

$controllers = array(
    'storefront' => array('responses/extension/stripe'),
    'admin'      => array(
        'responses/extension/stripe',
        'pages/extension/stripe_settings',
    ),
);

$models = array(
    'storefront' => array('extension/stripe'),
    'admin'      => array('extension/stripe'),
);

$languages = array(
    'storefront' => array(
        'stripe/stripe',
    ),
    'admin'      => array(
        'stripe/stripe',
    ),
);

$templates = array(
    'storefront' => array(
        'responses/stripe.tpl',
    ),
    'admin'      => array(
        'pages/extension/stripe_settings.tpl',
        'pages/sale/stripe_payment_details.tpl',
        'pages/catalog/subscription_product_form.tpl',
    ),
);